package org.mule.connectors.atlantic.commons.builder.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ExecutionConfigBuilder<T, R> {
    private final List<PreExecutionListener<T, R>> preExecutionListeners = new ArrayList<>();
    private final List<PostExecutionListener<T, R>> postExecutionListeners = new ArrayList<>();
    private final List<DefinedExceptionHandler<? extends Throwable, R>> exceptionHandlers = new ArrayList<>();

    public ExecutionConfigBuilder<T, R> withPreExecutionListener(PreExecutionListener<T, R> listener) {
        Optional.ofNullable(listener).ifPresent(preExecutionListeners::add);
        return this;
    }

    public ExecutionConfigBuilder<T, R> withPostExecutionListener(PostExecutionListener<T, R> listener) {
        Optional.ofNullable(listener).ifPresent(postExecutionListeners::add);
        return this;
    }

    public <C extends Throwable> ExecutionConfigBuilder<T, R> withExceptionHandler(Class<C> exceptionClass, ExceptionHandler<C, R> exceptionHandler) {
        return withExceptionHandler(new DefinedExceptionHandler<>(exceptionClass, exceptionHandler));
    }

    public <C extends Throwable> ExecutionConfigBuilder<T, R> withExceptionHandler(DefinedExceptionHandler<C, R> exceptionHandler) {
        exceptionHandlers.add(0, exceptionHandler);
        return this;
    }

    public ExecutionConfig<T, R> build() {
        return new ExecutionConfig<>(preExecutionListeners, postExecutionListeners, exceptionHandlers);
    }
}
