package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.BiConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.Consumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.PentaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.TetraConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.TriConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HexaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.PentaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TetraFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TriFunction;

import java.util.Optional;

public class ExecutionBuilder<T> {
    private final T executingObject;
    private ExecutionConfig config = new ExecutionConfig(null, null, null);

    public ExecutionBuilder(T executingObject) {
        this.executingObject = executingObject;
    }

    public ExecutionBuilder<T> withConfig(ExecutionConfig config) {
        this.config = Optional.ofNullable(config).orElse(this.config);
        return this;
    }

    public <A, B, C, D> TetraParamExecutionBuilder<T, A, B, C, D, Void> execute(PentaConsumer<T, A, B, C, D> executionStrategy) {
        return new TetraParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), config);
    }

    public <A, B, C> TriParamExecutionBuilder<T, A, B, C, Void> execute(TetraConsumer<T, A, B, C> executionStrategy) {
        return new TriParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), config);
    }

    public <A, B> BiParamExecutionBuilder<T, A, B, Void> execute(TriConsumer<T, A, B> executionStrategy) {
        return new BiParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), config);
    }

    public <A> MonoParamExecutionBuilder<T, A, Void> execute(BiConsumer<T, A> executionStrategy) {
        return new MonoParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), config);
    }

    public void execute(Consumer<T> executionStrategy) {
        new NoParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), config).execute();
    }

    public <A, B, C, D, E, R> PentaParamExecutionBuilder<T, A, B, C, D, E, R> execute(HexaFunction<T, A, B, C, D, E, R> executionStrategy) {
        return new PentaParamExecutionBuilder<>(executingObject, executionStrategy, config);
    }

    public <A, B, C, D, R> TetraParamExecutionBuilder<T, A, B, C, D, R> execute(PentaFunction<T, A, B, C, D, R> executionStrategy) {
        return new TetraParamExecutionBuilder<>(executingObject, executionStrategy, config);
    }

    public <A, B, C, R> TriParamExecutionBuilder<T, A, B, C, R> execute(TetraFunction<T, A, B, C, R> executionStrategy) {
        return new TriParamExecutionBuilder<>(executingObject, executionStrategy, config);
    }

    public <A, B, R> BiParamExecutionBuilder<T, A, B, R> execute(TriFunction<T, A, B, R> executionStrategy) {
        return new BiParamExecutionBuilder<>(executingObject, executionStrategy, config);
    }

    public <A, R> MonoParamExecutionBuilder<T, A, R> execute(BiFunction<T, A, R> executionStrategy) {
        return new MonoParamExecutionBuilder<>(executingObject, executionStrategy, config);
    }

    public <R> R execute(Function<T, R> executionStrategy) {
        return new NoParamExecutionBuilder<T, R>(executingObject, executionStrategy, config).execute();
    }

}
