package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.exception.UnhandledException;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.List;

public class NoParamExecutionBuilder<T, R> extends AbstractExecutionBuilder<T, Function<T, R>, R> {

    public NoParamExecutionBuilder(T executingObject,
                                   Function<T, R> executionStrategy,
                                   ExecutionConfig<T, R> config,
                                   List<Object> params) {
        super(executingObject, executionStrategy, config, params);
    }

    public NoParamExecutionBuilder(T executingObject,
                                   Function<T, R> executionStrategy,
                                   ExecutionConfig<T, R> config) {
        super(executingObject, executionStrategy, config);
    }


    public R execute() {
        try {
            return onPostExecute(onPreExecute(getExecutionStrategy()).apply(getExecutingObject()));
        } catch (Throwable t) {
            try {
                return getConfig().getExceptionHandlers()
                        .stream()
                        .filter(handler -> handler.getHandledException()
                                .isInstance(t))
                        .findFirst()
                        .orElseThrow(() -> new UnhandledException(t))
                        .handle(t);
            } catch(RuntimeException e) {
                throw e;
            } catch (Throwable throwable) {
                throw new UnhandledException(throwable);
            }
        }
    }
}
