package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HexaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class PentaParamExecutionBuilder<T, A, B, C, D, E, R> extends GenericExecutionBuilder<T, HexaFunction<T, A, B, C, D, E, R>, A, TetraParamExecutionBuilder<T, B, C, D, E, R>, R> {

    public PentaParamExecutionBuilder(T executingObject,
                                      HexaFunction<T, A, B, C, D, E, R> executionStrategy,
                                      ExecutionConfig<T, R> config,
                                      List<Object> params) {
        super(executingObject, executionStrategy, config, params);
    }

    public PentaParamExecutionBuilder(T executingObject,
                                      HexaFunction<T, A, B, C, D, E, R> executionStrategy,
                                      ExecutionConfig<T, R> config) {
        super(executingObject, executionStrategy, config);
    }


    @Override
    public TetraParamExecutionBuilder<T, B, C, D, E, R> withParam(A currentParam) {
        return new TetraParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam, fifthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam, fifthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()));
    }
}
