package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.PentaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class TetraParamExecutionBuilder<T, A, B, C, D, R> extends GenericExecutionBuilder<T, PentaFunction<T, A, B, C, D, R>, A, TriParamExecutionBuilder<T, B, C, D, R>, R> {

    public TetraParamExecutionBuilder(T executingObject,
                                      PentaFunction<T, A, B, C, D, R> executionStrategy,
                                      ExecutionConfig<T, R> config,
                                      List<Object> params) {
        super(executingObject, executionStrategy, config, params);
    }

    public TetraParamExecutionBuilder(T executingObject,
                                      PentaFunction<T, A, B, C, D, R> executionStrategy,
                                      ExecutionConfig<T, R> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public TriParamExecutionBuilder<T, B, C, D, R> withParam(A currentParam) {
        return new TriParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()));
    }
}
