package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TetraFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class TriParamExecutionBuilder<T, A, B, C, R> extends GenericExecutionBuilder<T, TetraFunction<T, A, B, C, R>, A, BiParamExecutionBuilder<T, B, C, R>, R> {

    public TriParamExecutionBuilder(T executingObject,
                                    TetraFunction<T, A, B, C, R> executionStrategy,
                                    ExecutionConfig<T, R> config,
                                    List<Object> params) {
        super(executingObject, executionStrategy, config, params);
    }

    public TriParamExecutionBuilder(T executingObject,
                                    TetraFunction<T, A, B, C, R> executionStrategy,
                                    ExecutionConfig<T, R> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public BiParamExecutionBuilder<T, B, C, R> withParam(A currentParam) {
        return new BiParamExecutionBuilder<>(getExecutingObject(),
                (executingObject, secondParam, thirdParam) -> getExecutionStrategy().apply(executingObject, currentParam, secondParam, thirdParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()));
    }
}
