/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.atlantic.commons.builder.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.connectors.atlantic.commons.builder.config.DefinedExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.PostExecutionListener;
import org.mule.connectors.atlantic.commons.builder.config.PreExecutionListener;

public class ExecutionConfig<T, R> {
    private final List<PreExecutionListener<T, R>> preExecutionListeners;
    private final List<PostExecutionListener<T, R>> postExecutionListeners;
    private final List<DefinedExceptionHandler<? extends Throwable, R>> exceptionHandlers;

    public ExecutionConfig(List<PreExecutionListener<T, R>> preExecutionListeners, List<PostExecutionListener<T, R>> postExecutionListeners, List<DefinedExceptionHandler<? extends Throwable, R>> exceptionHandlers) {
        this.preExecutionListeners = Optional.ofNullable(preExecutionListeners).orElseGet(ArrayList::new);
        this.postExecutionListeners = Optional.ofNullable(postExecutionListeners).orElseGet(ArrayList::new);
        this.exceptionHandlers = Optional.ofNullable(exceptionHandlers).orElseGet(ArrayList::new);
    }

    public List<PreExecutionListener<T, R>> getPreExecutionListeners() {
        return this.preExecutionListeners;
    }

    public List<PostExecutionListener<T, R>> getPostExecutionListeners() {
        return this.postExecutionListeners;
    }

    public List<DefinedExceptionHandler<? extends Throwable, R>> getExceptionHandlers() {
        return this.exceptionHandlers;
    }
}

