/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.atlantic.commons.builder.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.connectors.atlantic.commons.builder.config.DefinedExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.ExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.config.PostExecutionListener;
import org.mule.connectors.atlantic.commons.builder.config.PreExecutionListener;

public class ExecutionConfigBuilder<T, R> {
    private final List<PreExecutionListener<T, R>> preExecutionListeners = new ArrayList<PreExecutionListener<T, R>>();
    private final List<PostExecutionListener<T, R>> postExecutionListeners = new ArrayList<PostExecutionListener<T, R>>();
    private final List<DefinedExceptionHandler<? extends Throwable, R>> exceptionHandlers = new ArrayList<DefinedExceptionHandler<? extends Throwable, R>>();

    public ExecutionConfigBuilder<T, R> withPreExecutionListener(PreExecutionListener<T, R> listener) {
        Optional.ofNullable(listener).ifPresent(this.preExecutionListeners::add);
        return this;
    }

    public ExecutionConfigBuilder<T, R> withPostExecutionListener(PostExecutionListener<T, R> listener) {
        Optional.ofNullable(listener).ifPresent(this.postExecutionListeners::add);
        return this;
    }

    public <C extends Throwable> ExecutionConfigBuilder<T, R> withExceptionHandler(Class<C> exceptionClass, ExceptionHandler<C, R> exceptionHandler) {
        return this.withExceptionHandler(new DefinedExceptionHandler<C, R>(exceptionClass, exceptionHandler));
    }

    public <C extends Throwable> ExecutionConfigBuilder<T, R> withExceptionHandler(DefinedExceptionHandler<C, R> exceptionHandler) {
        this.exceptionHandlers.add(0, exceptionHandler);
        return this;
    }

    public ExecutionConfig<T, R> build() {
        return new ExecutionConfig<T, R>(this.preExecutionListeners, this.postExecutionListeners, this.exceptionHandlers);
    }
}

