package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ConfigurableBuilder;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.*;
import org.mule.connectors.atlantic.commons.builder.lambda.supplier.Supplier;

public class ClassBuilder extends ConfigurableBuilder<Void, ClassBuilder> {

    public <A, B, C, D, E, R> PentaParamClassBuilder<A, B, C, D, E, R> create(PentaFunction<A, B, C, D, E, R> executionStrategy) {
        return new PentaParamClassBuilder<>(executionStrategy, getConfig());
    }

    public <A, B, C, D, R> TetraParamClassBuilder<A, B, C, D, R> create(TetraFunction<A, B, C, D, R> executionStrategy) {
        return new TetraParamClassBuilder<>(executionStrategy, getConfig());
    }

    public <A, B, C, R> TriParamClassBuilder<A, B, C, R> create(TriFunction<A, B, C, R> executionStrategy) {
        return new TriParamClassBuilder<>(executionStrategy, getConfig());
    }

    public <A, B, R> BiParamClassBuilder<A, B, R> create(BiFunction<A, B, R> executionStrategy) {
        return new BiParamClassBuilder<>(executionStrategy, getConfig());
    }

    public <A, R> MonoParamClassBuilder<A, R> create(Function<A, R> executionStrategy) {
        return new MonoParamClassBuilder<>(executionStrategy, getConfig());
    }

    public <R> ExecutionBuilder<R> create(Supplier<R> executionStrategy) {
        return new NoParamClassBuilder<>(executionStrategy, getConfig()).create();
    }

}
