package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.config.PreExecutionListener;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.ArrayList;
import java.util.List;

public class AbstractExecutionBuilder<T, FUNCTION, R> {
    private final FUNCTION executionStrategy;
    private final T executingObject;
    private final ExecutionConfig<T> config;
    private final List<Object> params;

    public AbstractExecutionBuilder(T executingObject,
                                    FUNCTION executionStrategy,
                                    ExecutionConfig config) {
        this(executingObject, executionStrategy, config, new ArrayList<>());
    }

    public AbstractExecutionBuilder(T service,
                                    FUNCTION executionStrategy,
                                    ExecutionConfig config,
                                    List<Object> params) {
        this.executionStrategy = executionStrategy;
        this.executingObject = service;
        this.config = config;
        this.params = params;
    }

    protected void onPreExecute() {
        config.getPreExecutionListeners().forEach(listener -> listener.onPreExecute(executingObject, params));
    }

    protected FUNCTION getExecutionStrategy() {
        return executionStrategy;
    }

    protected T getExecutingObject() {
        return executingObject;
    }

    protected ExecutionConfig<T> getConfig() {
        return config;
    }

    protected List<Object> getParams() {
        return params;
    }
}
