package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TriFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class BiParamExecutionBuilder<T, A, B, R> extends GenericExecutionBuilder<T, TriFunction<T, A, B, R>, A, MonoParamExecutionBuilder<T, B, R>, R> {

    public BiParamExecutionBuilder(T executingObject,
                                   TriFunction<T, A, B, R> executionStrategy,
                                   ExecutionConfig<T> config,
                                   List<Object> params) {
        super(executingObject, executionStrategy, config, params);
    }

    public BiParamExecutionBuilder(T executingObject,
                                   TriFunction<T, A, B, R> executionStrategy,
                                   ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public MonoParamExecutionBuilder<T, B, R> withParam(A currentParam) {
        return new MonoParamExecutionBuilder<>(getExecutingObject(),
                (executingObject, secondParam) -> getExecutionStrategy().apply(executingObject, currentParam, secondParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()));
    }
}
