package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.exception.UnhandledException;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.List;

public class NoParamExecutionBuilder<T, R> extends AbstractExecutionBuilder<T, Function<T, R>, R> {

    public NoParamExecutionBuilder(T executingObject,
                                   Function<T, R> executionStrategy,
                                   ExecutionConfig<T> config,
                                   List<Object> params) {
        super(executingObject, executionStrategy, config, params);
    }

    public NoParamExecutionBuilder(T executingObject,
                                   Function<T, R> executionStrategy,
                                   ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }


    public R execute() {
        return getConfig().getExecutor().execute(getConfig(), getExecutingObject(), getExecutionStrategy(), getParams());
    }
}
