/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.atlantic.commons.builder.config;

import java.util.Optional;
import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.config.PreExecutionListener;
import org.mule.connectors.atlantic.commons.builder.config.exception.DefinedExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.exception.ExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.executor.Executor;

public class ConfigurableBuilder<T, B extends ConfigurableBuilder> {
    private ExecutionConfig<T> config = new ExecutionConfig();

    public B withPreExecutionListener(PreExecutionListener<T> listener) {
        Optional.ofNullable(listener).ifPresent(this.config.getPreExecutionListeners()::add);
        return (B)this;
    }

    public <C extends Throwable> B withExceptionHandler(Class<C> exceptionClass, ExceptionHandler<C> exceptionHandler) {
        return this.withExceptionHandler(new DefinedExceptionHandler<C>(exceptionClass, exceptionHandler));
    }

    public <C extends Throwable> B withExceptionHandler(DefinedExceptionHandler<C> exceptionHandler) {
        this.config.getExceptionHandlers().add(0, exceptionHandler);
        return (B)this;
    }

    public B withExecutor(Executor executor) {
        this.config.setExecutor(executor);
        return (B)this;
    }

    protected ExecutionConfig<T> getConfig() {
        return this.config;
    }
}

