/*
 * Decompiled with CFR 0.152.
 */
package org.mule.connectors.atlantic.commons.builder.execution;

import java.util.ArrayList;
import java.util.List;
import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;

public class AbstractExecutionBuilder<T, FUNCTION, R> {
    private final FUNCTION executionStrategy;
    private final T executingObject;
    private final ExecutionConfig<T> config;
    private final List<Object> params;

    public AbstractExecutionBuilder(T executingObject, FUNCTION executionStrategy, ExecutionConfig config) {
        this(executingObject, executionStrategy, config, new ArrayList<Object>());
    }

    public AbstractExecutionBuilder(T service, FUNCTION executionStrategy, ExecutionConfig config, List<Object> params) {
        this.executionStrategy = executionStrategy;
        this.executingObject = service;
        this.config = config;
        this.params = params;
    }

    protected void onPreExecute() {
        this.config.getPreExecutionListeners().forEach(listener -> listener.onPreExecute(this.executingObject, this.params));
    }

    protected FUNCTION getExecutionStrategy() {
        return this.executionStrategy;
    }

    protected T getExecutingObject() {
        return this.executingObject;
    }

    protected ExecutionConfig<T> getConfig() {
        return this.config;
    }

    protected List<Object> getParams() {
        return this.params;
    }
}

