package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.exception.UnhandledException;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.supplier.Supplier;

public class NoParamClassBuilder<R> extends AbstractClassBuilder<Supplier<R>, R> {

    public NoParamClassBuilder(Supplier<R> executionStrategy,
                               ExecutionConfig<Void> config) {
        super(executionStrategy, config);
    }

    public ExecutionBuilder<R> create() {

        try {
            return new ExecutionBuilder<>(getExecutionStrategy().apply());
        } catch (Throwable t) {
            getConfig().getExceptionHandlers()
                    .stream()
                    .filter(handler -> handler.getHandledException()
                            .isInstance(t))
                    .findFirst()
                    .orElseThrow(() -> new UnhandledException(t))
                    .handle(t);
            return null;
        }
    }
}
