package org.mule.connectors.atlantic.commons.builder.config.executor;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.List;
import java.util.function.Consumer;

public class AsynchronousExecutor extends DefaultExecutor {

    private final Consumer onExecutionFinishedListener;

    public AsynchronousExecutor(Consumer<?> onExecutionFinishedListener) {
        this.onExecutionFinishedListener = onExecutionFinishedListener;
    }

    @Override
    public <T, R> R execute(ExecutionConfig<T> config, T executingObject, Function<T, R> executionStrategy, List<Object> params) {
        new Thread(() -> onExecutionFinishedListener.accept(super.execute(config, executingObject, executionStrategy, params))).start();
        return null;
    }
}
