package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.*;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.BiConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.Consumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.HexaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.PentaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.TetraConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.TriConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HexaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.PentaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TetraFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TriFunction;

import java.util.Optional;

public class ExecutionBuilder<T> extends ConfigurableBuilder<T, ExecutionBuilder<T>> {
    private final T executingObject;

    public ExecutionBuilder(T executingObject) {
        this.executingObject = executingObject;
    }

    public <A, B, C, D, E> PentaParamExecutionBuilder<T, A, B, C, D, E, Void> execute(HexaConsumer<T, A, B, C, D, E> executionStrategy) {
        return new PentaParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C, D> TetraParamExecutionBuilder<T, A, B, C, D, Void> execute(PentaConsumer<T, A, B, C, D> executionStrategy) {
        return new TetraParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C> TriParamExecutionBuilder<T, A, B, C, Void> execute(TetraConsumer<T, A, B, C> executionStrategy) {
        return new TriParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B> BiParamExecutionBuilder<T, A, B, Void> execute(TriConsumer<T, A, B> executionStrategy) {
        return new BiParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A> MonoParamExecutionBuilder<T, A, Void> execute(BiConsumer<T, A> executionStrategy) {
        return new MonoParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public void execute(Consumer<T> executionStrategy) {
        new NoParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig()).execute();
    }

    public <A, B, C, D, E, R> PentaParamExecutionBuilder<T, A, B, C, D, E, R> execute(HexaFunction<T, A, B, C, D, E, R> executionStrategy) {
        return new PentaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, D, R> TetraParamExecutionBuilder<T, A, B, C, D, R> execute(PentaFunction<T, A, B, C, D, R> executionStrategy) {
        return new TetraParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, R> TriParamExecutionBuilder<T, A, B, C, R> execute(TetraFunction<T, A, B, C, R> executionStrategy) {
        return new TriParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, R> BiParamExecutionBuilder<T, A, B, R> execute(TriFunction<T, A, B, R> executionStrategy) {
        return new BiParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, R> MonoParamExecutionBuilder<T, A, R> execute(BiFunction<T, A, R> executionStrategy) {
        return new MonoParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <R> R execute(Function<T, R> executionStrategy) {
        return new NoParamExecutionBuilder<T, R>(executingObject, executionStrategy, getConfig()).execute();
    }

}
