package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;

import java.util.List;

public class MonoParamExecutionBuilder<T, A, R> extends GenericExecutionBuilder<T, BiFunction<T, A, R>, A, R, R> {

    public MonoParamExecutionBuilder(T executingObject,
                                     BiFunction<T, A, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     List<Object> params) {
        super(executingObject, executionStrategy, config, params);
    }

    public MonoParamExecutionBuilder(T executingObject,
                                     BiFunction<T, A, R> executionStrategy,
                                     ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public R withParam(A currentParam) {
        return new NoParamExecutionBuilder<>(getExecutingObject(),
                executingObject -> getExecutionStrategy().apply(executingObject, currentParam),
                getConfig(),
                getParams()).execute();
    }
}
