package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.execution.ExecutionBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

public class MonoParamClassBuilder<A, R> extends GenericClassBuilder<Function<A, R>, A, ExecutionBuilder<R>, R> {

    public MonoParamClassBuilder(Function<A, R> executionStrategy, ExecutionConfig<Void> config) {
        super(executionStrategy, config);
    }

    @Override
    public ExecutionBuilder<R> withParam(A currentParam) {
        return new NoParamClassBuilder<>(() -> getExecutionStrategy().apply(currentParam), getConfig()).create();
    }
}
