package org.mule.connectors.atlantic.commons.builder.clazz;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TriFunction;

public class TriParamClassBuilder<A, B, C, R> extends GenericClassBuilder<TriFunction<A, B, C, R>, A, BiParamClassBuilder<B, C, R>, R> {

    public TriParamClassBuilder(TriFunction<A, B, C, R> executionStrategy, ExecutionConfig<Void> config) {
        super(executionStrategy, config);
    }

    @Override
    public BiParamClassBuilder<B, C, R> withParam(A currentParam) {
        return new BiParamClassBuilder<>((secondParam, thirdParam) -> getExecutionStrategy().apply(currentParam, secondParam, thirdParam), getConfig());
    }
}
