package org.mule.connectors.atlantic.commons.builder.config;

import org.mule.connectors.atlantic.commons.builder.config.exception.DefinedExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.exception.ExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.executor.Executor;

import java.util.Optional;

public class ConfigurableBuilder<T, B extends ConfigurableBuilder> {
    private ExecutionConfig<T> config = new ExecutionConfig();

    public B withPreExecutionListener(PreExecutionListener<T> listener) {
        Optional.ofNullable(listener).ifPresent(config.getPreExecutionListeners()::add);
        return (B)this;
    }

    public <C extends Throwable> B withExceptionHandler(Class<C> exceptionClass, ExceptionHandler<C> exceptionHandler) {
        return withExceptionHandler(new DefinedExceptionHandler<>(exceptionClass, exceptionHandler));
    }

    public <C extends Throwable> B withExceptionHandler(DefinedExceptionHandler<C> exceptionHandler) {
        config.getExceptionHandlers().add(0, exceptionHandler);
        return (B)this;
    }

    public B withExecutor(Executor executor) {
        config.setExecutor(executor);
        return (B)this;
    }

    protected ExecutionConfig<T> getConfig() {
        return config;
    }
}
