package org.mule.connectors.atlantic.commons.builder.config;

import org.mule.connectors.atlantic.commons.builder.config.exception.DefinedExceptionHandler;
import org.mule.connectors.atlantic.commons.builder.config.executor.DefaultExecutor;
import org.mule.connectors.atlantic.commons.builder.config.executor.Executor;

import java.util.ArrayList;
import java.util.List;

public class ExecutionConfig<T> {
    private final List<PreExecutionListener<T>> preExecutionListeners = new ArrayList<>();
    private final List<DefinedExceptionHandler<? extends Throwable>> exceptionHandlers = new ArrayList<>();
    private Executor executor = new DefaultExecutor();

    public List<PreExecutionListener<T>> getPreExecutionListeners() {
        return preExecutionListeners;
    }

    public List<DefinedExceptionHandler<? extends Throwable>> getExceptionHandlers() {
        return exceptionHandlers;
    }

    public Executor getExecutor() {
        return executor;
    }

    public void setExecutor(Executor executor) {
        this.executor = executor;
    }
}
