package org.mule.connectors.atlantic.commons.builder.config.exception;

public class DefinedExceptionHandler<T extends Throwable> implements ExceptionHandler<T> {
    private final Class<T> handledException;
    private final ExceptionHandler<T> exceptionHandler;

    public DefinedExceptionHandler(Class<T> handledException, ExceptionHandler<T> exceptionHandler) {
        this.handledException = handledException;
        this.exceptionHandler = exceptionHandler;
    }

    public Class<T> getHandledException() {
        return handledException;
    }

    @Override
    public void handle(Throwable throwable) {
        exceptionHandler.handle((T) throwable);
    }
}
