package org.mule.connectors.atlantic.commons.builder.config.executor;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.List;
import java.util.function.Consumer;

public class AsynchronousExecutor extends DefaultExecutor {

    private final Consumer onExecutionFinishedListener;

    public AsynchronousExecutor(Consumer<?> onExecutionFinishedListener) {
        this.onExecutionFinishedListener = onExecutionFinishedListener;
    }

    @Override
    public <T, R, PR> PR execute(ExecutionConfig<T> config, T executingObject, Function<T, R> executionStrategy, List<Object> params, Function<R, PR> resultParser) {
        new Thread(() -> onExecutionFinishedListener.accept(super.execute(config, executingObject, executionStrategy, params, resultParser))).start();
        return null;
    }
}
