package org.mule.connectors.atlantic.commons.builder.config.executor;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.exception.UnhandledException;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.List;

public class DefaultExecutor implements Executor {
    @Override
    public <T, R, PR> PR execute(ExecutionConfig<T> config, T executingObject, Function<T, R> executionStrategy, List<Object> params, Function<R, PR> resultParser) {
        try {
            config.getPreExecutionListeners().forEach(listener -> listener.onPreExecute(executingObject, params));
            return resultParser.apply(executionStrategy.apply(executingObject));
        } catch (Throwable t) {
            config.getExceptionHandlers()
                    .stream()
                    .filter(handler -> handler.getHandledException().isInstance(t))
                    .findFirst()
                    .orElseThrow(() -> new UnhandledException(t))
                    .handle(t);
            return null;
        }
    }
}
