package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.ArrayList;
import java.util.List;

public class AbstractExecutionBuilder<T, FUNCTION, R, PR> {
    private final FUNCTION executionStrategy;
    private final T executingObject;
    private final ExecutionConfig<T> config;
    private final List<Object> params;
    private final Function<R, PR> resultParser;

    public AbstractExecutionBuilder(T executingObject,
                                    FUNCTION executionStrategy,
                                    ExecutionConfig config) {
        this(executingObject, executionStrategy, config, new ArrayList<>(), a -> (PR) a);
    }

    public AbstractExecutionBuilder(T executingObject,
                                    FUNCTION executionStrategy,
                                    ExecutionConfig config,
                                    Function<R, PR> resultParser) {
        this(executingObject, executionStrategy, config, new ArrayList<>(), resultParser);
    }

    public AbstractExecutionBuilder(T service,
                                    FUNCTION executionStrategy,
                                    ExecutionConfig config,
                                    List<Object> params,
                                    Function<R, PR> resultParser) {
        this.executionStrategy = executionStrategy;
        this.executingObject = service;
        this.config = config;
        this.params = params;
        this.resultParser = resultParser;
    }

    protected FUNCTION getExecutionStrategy() {
        return executionStrategy;
    }

    protected T getExecutingObject() {
        return executingObject;
    }

    protected ExecutionConfig<T> getConfig() {
        return config;
    }

    protected List<Object> getParams() {
        return params;
    }

    protected Function<R, PR> getResultParser() {
        return resultParser;
    }
}
