package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.exception.ConversionException;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.List;

public abstract class GenericExecutionBuilder<T, FUNCTION, PARAM, GET_PARAM_RESULT, R, PR> extends AbstractExecutionBuilder<T, FUNCTION, R, PR> {

    public GenericExecutionBuilder(T executingObject, FUNCTION executionStrategy, ExecutionConfig<T> config, List<Object> params, Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public GenericExecutionBuilder(T executingObject, FUNCTION executionStrategy, ExecutionConfig<T> config, Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public GenericExecutionBuilder(T executingObject, FUNCTION executionStrategy, ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    public abstract GET_PARAM_RESULT withParam(PARAM currentParam);

    public <F> GET_PARAM_RESULT withParam(F from, Function<F, PARAM> converter) {
        try {
            return withParam(converter.apply(from));
        } catch (Throwable t) {
            throw new ConversionException(from, t);
        }
    }
}
