package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.DecaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.NonaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class NonaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, R, PR> extends GenericExecutionBuilder<T, DecaFunction<T, A, B, C, D, E, F, G, H, I, R>, A, OctaParamExecutionBuilder<T, B, C, D, E, F, G, H, I, R, PR>, R, PR> {

    public NonaParamExecutionBuilder(T executingObject,
                                     DecaFunction<T, A, B, C, D, E, F, G, H, I, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     List<Object> params,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public NonaParamExecutionBuilder(T executingObject,
                                     DecaFunction<T, A, B, C, D, E, F, G, H, I, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public NonaParamExecutionBuilder(T executingObject,
                                     DecaFunction<T, A, B, C, D, E, F, G, H, I, R> executionStrategy,
                                     ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public OctaParamExecutionBuilder<T, B, C, D, E, F, G, H, I, R, PR> withParam(A currentParam) {
        return new OctaParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam, eighthParam, ninthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam, eighthParam, ninthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()),
                getResultParser());
    }
}
