package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.NonaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.OctaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class OctaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, R, PR> extends GenericExecutionBuilder<T, NonaFunction<T, A, B, C, D, E, F, G, H, R>, A, HeptaParamExecutionBuilder<T, B, C, D, E, F, G, H, R, PR>, R, PR> {

    public OctaParamExecutionBuilder(T executingObject,
                                     NonaFunction<T, A, B, C, D, E, F, G, H, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     List<Object> params,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public OctaParamExecutionBuilder(T executingObject,
                                     NonaFunction<T, A, B, C, D, E, F, G, H, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public OctaParamExecutionBuilder(T executingObject,
                                     NonaFunction<T, A, B, C, D, E, F, G, H, R> executionStrategy,
                                     ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public HeptaParamExecutionBuilder<T, B, C, D, E, F, G, H, R, PR> withParam(A currentParam) {
        return new HeptaParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam, eighthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam, eighthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()),
                getResultParser());
    }
}
