package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HexaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class PentaParamExecutionBuilder<T, A, B, C, D, E, R, PR> extends GenericExecutionBuilder<T, HexaFunction<T, A, B, C, D, E, R>, A, TetraParamExecutionBuilder<T, B, C, D, E, R, PR>, R, PR> {

    public PentaParamExecutionBuilder(T executingObject,
                                      HexaFunction<T, A, B, C, D, E, R> executionStrategy,
                                      ExecutionConfig<T> config,
                                      List<Object> params,
                                      Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public PentaParamExecutionBuilder(T executingObject,
                                      HexaFunction<T, A, B, C, D, E, R> executionStrategy,
                                      ExecutionConfig<T> config,
                                      Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public PentaParamExecutionBuilder(T executingObject,
                                      HexaFunction<T, A, B, C, D, E, R> executionStrategy,
                                      ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public TetraParamExecutionBuilder<T, B, C, D, E, R, PR> withParam(A currentParam) {
        return new TetraParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam, fifthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam, fifthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()),
                getResultParser());
    }
}
