package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.PentaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class TetraParamExecutionBuilder<T, A, B, C, D, R, PR> extends GenericExecutionBuilder<T, PentaFunction<T, A, B, C, D, R>, A, TriParamExecutionBuilder<T, B, C, D, R, PR>, R, PR> {

    public TetraParamExecutionBuilder(T executingObject,
                                      PentaFunction<T, A, B, C, D, R> executionStrategy,
                                      ExecutionConfig<T> config,
                                      List<Object> params,
                                      Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public TetraParamExecutionBuilder(T executingObject,
                                      PentaFunction<T, A, B, C, D, R> executionStrategy,
                                      ExecutionConfig<T> config,
                                      Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public TetraParamExecutionBuilder(T executingObject,
                                      PentaFunction<T, A, B, C, D, R> executionStrategy,
                                      ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public TriParamExecutionBuilder<T, B, C, D, R, PR> withParam(A currentParam) {
        return new TriParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()),
                getResultParser());
    }
}
