package org.mule.connectors.atlantic.commons.builder.lambda.consumer;

import org.mule.connectors.atlantic.commons.builder.lambda.function.TriFunction;

public interface TriConsumer<A, B, C> {
    void execute(A a, B b, C c) throws Throwable;

    default TriFunction<A, B, C, Void> toFunction() {
        return (a, b, c) -> {
            execute(a, b, c);
            return null;
        };
    }
}
