package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HendecaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class DecaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, J, R, PR> extends GenericExecutionBuilder<T, HendecaFunction<T, A, B, C, D, E, F, G, H, I, J, R>, A, NonaParamExecutionBuilder<T, B, C, D, E, F, G, H, I, J, R, PR>, R, PR> {

    public DecaParamExecutionBuilder(T executingObject,
                                     HendecaFunction<T, A, B, C, D, E, F, G, H, I, J, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     List<Object> params,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public DecaParamExecutionBuilder(T executingObject,
                                     HendecaFunction<T, A, B, C, D, E, F, G, H, I, J, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public DecaParamExecutionBuilder(T executingObject,
                                     HendecaFunction<T, A, B, C, D, E, F, G, H, I, J, R> executionStrategy,
                                     ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public NonaParamExecutionBuilder<T, B, C, D, E, F, G, H, I, J, R, PR> withParam(A currentParam) {
        return new NonaParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam, eighthParam, ninthParam, tenthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam, eighthParam, ninthParam, tenthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()),
                getResultParser());
    }
}
