package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ConfigurableBuilder;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.BiConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.Consumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.DecaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.HendecaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.HeptaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.HexaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.NonaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.OctaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.PentaConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.TetraConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.consumer.TriConsumer;
import org.mule.connectors.atlantic.commons.builder.lambda.function.BiFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.DecaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HendecaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HeptaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HexaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.NonaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.OctaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.PentaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TetraFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.TriFunction;

public class ExecutionBuilder<T> extends ConfigurableBuilder<T, ExecutionBuilder<T>> {
    private final T executingObject;

    public ExecutionBuilder(T executingObject) {
        this.executingObject = executingObject;
    }

    public <A, B, C, D, E, F, G, H, I, J> DecaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, J, Void, Void> execute(HendecaConsumer<T, A, B, C, D, E, F, G, H, I, J> executionStrategy) {
        return new DecaParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C, D, E, F, G, H, I> NonaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, Void, Void> execute(DecaConsumer<T, A, B, C, D, E, F, G, H, I> executionStrategy) {
        return new NonaParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C, D, E, F, G, H> OctaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, Void, Void> execute(NonaConsumer<T, A, B, C, D, E, F, G, H> executionStrategy) {
        return new OctaParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C, D, E, F, G> HeptaParamExecutionBuilder<T, A, B, C, D, E, F, G, Void, Void> execute(OctaConsumer<T, A, B, C, D, E, F, G> executionStrategy) {
        return new HeptaParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C, D, E, F> HexaParamExecutionBuilder<T, A, B, C, D, E, F, Void, Void> execute(HeptaConsumer<T, A, B, C, D, E, F> executionStrategy) {
        return new HexaParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C, D, E> PentaParamExecutionBuilder<T, A, B, C, D, E, Void, Void> execute(HexaConsumer<T, A, B, C, D, E> executionStrategy) {
        return new PentaParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C, D> TetraParamExecutionBuilder<T, A, B, C, D, Void, Void> execute(PentaConsumer<T, A, B, C, D> executionStrategy) {
        return new TetraParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B, C> TriParamExecutionBuilder<T, A, B, C, Void, Void> execute(TetraConsumer<T, A, B, C> executionStrategy) {
        return new TriParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A, B> BiParamExecutionBuilder<T, A, B, Void, Void> execute(TriConsumer<T, A, B> executionStrategy) {
        return new BiParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public <A> MonoParamExecutionBuilder<T, A, Void, Void> execute(BiConsumer<T, A> executionStrategy) {
        return new MonoParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig());
    }

    public void execute(Consumer<T> executionStrategy) {
        new NoParamExecutionBuilder<>(executingObject, executionStrategy.toFunction(), getConfig()).execute();
    }

    public <A, B, C, D, E, F, G, H, I, J, R> DecaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, J, R, R> execute(HendecaFunction<T, A, B, C, D, E, F, G, H, I, J, R> executionStrategy) {
        return new DecaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, D, E, F, G, H, I, R> NonaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, R, R> execute(DecaFunction<T, A, B, C, D, E, F, G, H, I, R> executionStrategy) {
        return new NonaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, D, E, F, G, H, R> OctaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, R, R> execute(NonaFunction<T, A, B, C, D, E, F, G, H, R> executionStrategy) {
        return new OctaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, D, E, F, G, R> HeptaParamExecutionBuilder<T, A, B, C, D, E, F, G, R, R> execute(OctaFunction<T, A, B, C, D, E, F, G, R> executionStrategy) {
        return new HeptaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, D, E, F, R> HexaParamExecutionBuilder<T, A, B, C, D, E, F, R, R> execute(HeptaFunction<T, A, B, C, D, E, F, R> executionStrategy) {
        return new HexaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, D, E, R> PentaParamExecutionBuilder<T, A, B, C, D, E, R, R> execute(HexaFunction<T, A, B, C, D, E, R> executionStrategy) {
        return new PentaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, D, R> TetraParamExecutionBuilder<T, A, B, C, D, R, R> execute(PentaFunction<T, A, B, C, D, R> executionStrategy) {
        return new TetraParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, C, R> TriParamExecutionBuilder<T, A, B, C, R, R> execute(TetraFunction<T, A, B, C, R> executionStrategy) {
        return new TriParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, B, R> BiParamExecutionBuilder<T, A, B, R, R> execute(TriFunction<T, A, B, R> executionStrategy) {
        return new BiParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <A, R> MonoParamExecutionBuilder<T, A, R, R> execute(BiFunction<T, A, R> executionStrategy) {
        return new MonoParamExecutionBuilder<>(executingObject, executionStrategy, getConfig());
    }

    public <R> R execute(Function<T, R> executionStrategy) {
        return new NoParamExecutionBuilder<T, R, R>(executingObject, executionStrategy, getConfig()).execute();
    }

    public <A, B, C, D, E, F, G, H, I, J, R, PR> DecaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, J, R, PR> execute(HendecaFunction<T, A, B, C, D, E, F, G, H, I, J, R> executionStrategy, Function<R, PR> resultParser) {
        return new DecaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, C, D, E, F, G, H, I, R, PR> NonaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, I, R, PR> execute(DecaFunction<T, A, B, C, D, E, F, G, H, I, R> executionStrategy, Function<R, PR> resultParser) {
        return new NonaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, C, D, E, F, G, H, R, PR> OctaParamExecutionBuilder<T, A, B, C, D, E, F, G, H, R, PR> execute(NonaFunction<T, A, B, C, D, E, F, G, H, R> executionStrategy, Function<R, PR> resultParser) {
        return new OctaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, C, D, E, F, G, R, PR> HeptaParamExecutionBuilder<T, A, B, C, D, E, F, G, R, PR> execute(OctaFunction<T, A, B, C, D, E, F, G, R> executionStrategy, Function<R, PR> resultParser) {
        return new HeptaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, C, D, E, F, R, PR> HexaParamExecutionBuilder<T, A, B, C, D, E, F, R, PR> execute(HeptaFunction<T, A, B, C, D, E, F, R> executionStrategy, Function<R, PR> resultParser) {
        return new HexaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, C, D, E, R, PR> PentaParamExecutionBuilder<T, A, B, C, D, E, R, PR> execute(HexaFunction<T, A, B, C, D, E, R> executionStrategy, Function<R, PR> resultParser) {
        return new PentaParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, C, D, R, PR> TetraParamExecutionBuilder<T, A, B, C, D, R, PR> execute(PentaFunction<T, A, B, C, D, R> executionStrategy, Function<R, PR> resultParser) {
        return new TetraParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, C, R, PR> TriParamExecutionBuilder<T, A, B, C, R, PR> execute(TetraFunction<T, A, B, C, R> executionStrategy, Function<R, PR> resultParser) {
        return new TriParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, B, R, PR> BiParamExecutionBuilder<T, A, B, R, PR> execute(TriFunction<T, A, B, R> executionStrategy, Function<R, PR> resultParser) {
        return new BiParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <A, R, PR> MonoParamExecutionBuilder<T, A, R, PR> execute(BiFunction<T, A, R> executionStrategy, Function<R, PR> resultParser) {
        return new MonoParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser);
    }

    public <R, PR> PR execute(Function<T, R> executionStrategy, Function<R, PR> resultParser) {
        return new NoParamExecutionBuilder<>(executingObject, executionStrategy, getConfig(), resultParser).execute();
    }

}
