package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HeptaFunction;
import org.mule.connectors.atlantic.commons.builder.lambda.function.OctaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class HeptaParamExecutionBuilder<T, A, B, C, D, E, F, G, R, PR> extends GenericExecutionBuilder<T, OctaFunction<T, A, B, C, D, E, F, G, R>, A, HexaParamExecutionBuilder<T, B, C, D, E, F, G, R, PR>, R, PR> {

    public HeptaParamExecutionBuilder(T executingObject,
                                      OctaFunction<T, A, B, C, D, E, F, G, R> executionStrategy,
                                      ExecutionConfig<T> config,
                                      List<Object> params,
                                      Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public HeptaParamExecutionBuilder(T executingObject,
                                      OctaFunction<T, A, B, C, D, E, F, G, R> executionStrategy,
                                      ExecutionConfig<T> config,
                                      Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public HeptaParamExecutionBuilder(T executingObject,
                                      OctaFunction<T, A, B, C, D, E, F, G, R> executionStrategy,
                                      ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public HexaParamExecutionBuilder<T, B, C, D, E, F, G, R, PR> withParam(A currentParam) {
        return new HexaParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam, fifthParam, sixthParam, seventhParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()),
                getResultParser());
    }
}
