package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;
import org.mule.connectors.atlantic.commons.builder.lambda.function.HeptaFunction;

import java.util.List;
import java.util.stream.Stream;

import static java.util.stream.Collectors.toList;
import static java.util.stream.Stream.concat;

public class HexaParamExecutionBuilder<T, A, B, C, D, E, F, R, PR> extends GenericExecutionBuilder<T, HeptaFunction<T, A, B, C, D, E, F, R>, A, PentaParamExecutionBuilder<T, B, C, D, E, F, R, PR>, R, PR> {

    public HexaParamExecutionBuilder(T executingObject,
                                     HeptaFunction<T, A, B, C, D, E, F, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     List<Object> params,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public HexaParamExecutionBuilder(T executingObject,
                                     HeptaFunction<T, A, B, C, D, E, F, R> executionStrategy,
                                     ExecutionConfig<T> config,
                                     Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public HexaParamExecutionBuilder(T executingObject,
                                     HeptaFunction<T, A, B, C, D, E, F, R> executionStrategy,
                                     ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    @Override
    public PentaParamExecutionBuilder<T, B, C, D, E, F, R, PR> withParam(A currentParam) {
        return new PentaParamExecutionBuilder<>(getExecutingObject(),
                (inputService, secondParam, thirdParam, fourthParam, fifthParam, sixthParam) -> getExecutionStrategy().apply(inputService, currentParam, secondParam, thirdParam, fourthParam, fifthParam, sixthParam),
                getConfig(),
                concat(Stream.of(currentParam), getParams().stream()).collect(toList()),
                getResultParser());
    }
}
