package org.mule.connectors.atlantic.commons.builder.execution;

import org.mule.connectors.atlantic.commons.builder.config.ExecutionConfig;
import org.mule.connectors.atlantic.commons.builder.lambda.function.Function;

import java.util.List;

public class NoParamExecutionBuilder<T, R, PR> extends AbstractExecutionBuilder<T, Function<T, R>, R, PR> {

    public NoParamExecutionBuilder(T executingObject,
                                   Function<T, R> executionStrategy,
                                   ExecutionConfig<T> config,
                                   List<Object> params,
                                   Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, params, resultParser);
    }

    public NoParamExecutionBuilder(T executingObject,
                                   Function<T, R> executionStrategy,
                                   ExecutionConfig<T> config,
                                   Function<R, PR> resultParser) {
        super(executingObject, executionStrategy, config, resultParser);
    }

    public NoParamExecutionBuilder(T executingObject,
                                   Function<T, R> executionStrategy,
                                   ExecutionConfig<T> config) {
        super(executingObject, executionStrategy, config);
    }

    public PR execute() {
        return getConfig().getExecutor().execute(getConfig(), getExecutingObject(), getExecutionStrategy(), getParams(), getResultParser());
    }
}
