package com.mule.connectors.interop.model;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import java.io.IOException;

/**
 * @author Mulesoft, Inc
 */
public class ManifestUnit {

    private String id;
    private String version;

    public ManifestUnit (String contentXmlPath) throws ParserConfigurationException, IOException, SAXException, XPathExpressionException {

        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document doc = builder.parse(contentXmlPath);

        XPathFactory xPathfactory = XPathFactory.newInstance();
        XPath xpath = xPathfactory.newXPath();
        Node unit = (Node) xpath.compile("//units/unit[contains(@id, 'ui.contribution')]").evaluate(doc, XPathConstants.NODE);

        id = ((Element) unit).getAttribute("id");
        version = ((Element) unit).getAttribute("version");
    }

    public String getVersion() {
        return version;
    }

    public String getId() {
        return id;
    }
}
