package com.mule.connectors.interop.model;

import org.apache.commons.lang.SystemUtils;
import org.xml.sax.SAXException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import java.io.File;
import java.io.IOException;

/**
 * @author Mulesoft, Inc
 */
public class UpdateSite {

    public static final String JAR_PREFIX = "jar:file:";
    private final String UPDATESITE_PATH = "/UpdateSite.zip!";
    private final String CONTENT_PATH = "/update-site/content.xml";

    private final File updateSite;
    private final String location;

    private ManifestUnit manifestUnit;
    private PlatformUnit platformUnit;

    public UpdateSite (String targetDir) throws IOException {

        updateSite = new File(targetDir, UPDATESITE_PATH);

        try {
            File content = new File(targetDir, CONTENT_PATH);

            manifestUnit = new ManifestUnit(content.getCanonicalPath());
            platformUnit = new PlatformUnit(content.getCanonicalPath());

        } catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new IOException(e);
        } catch (SAXException e) {
            e.printStackTrace();
            throw new IOException(e);
        } catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new IOException(e);
        }

        location = buildLocation();
    }

    public ManifestUnit getManifestUnit() {
        return manifestUnit;
    }

    public PlatformUnit getPlatformUnit() {
        return platformUnit;
    }

    public String getLocation() {
        return location;
    }

    private String buildLocation() throws IOException {

        return JAR_PREFIX + (SystemUtils.IS_OS_WINDOWS ? "/" : "") + updateSite.getCanonicalPath().replaceAll("\\\\", "/") + "/";
    }
}
