/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop;

import com.mule.connectors.interop.exceptions.CreatorMojoException;
import com.mule.connectors.interop.exceptions.ManifestUpdateException;
import com.mule.connectors.interop.exceptions.TargetPlatformUpdateException;
import com.mule.connectors.interop.model.Manifest;
import com.mule.connectors.interop.model.TargetPlatform;
import com.mule.connectors.interop.model.UpdateSite;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class RunnerCreatorMojo
extends AbstractMojo {
    private static final String BUNDLE_VERSION_0_0_0 = ";bundle-version=\"0.0.0\"\n";
    private String zipName = "interop-ce-project.zip";
    private String externalPlatform;
    private String manifestPath;
    private String platformPath;
    private String targetDir;
    private String baseDir;
    private Manifest manifest;
    private UpdateSite connectorUpdateSite;
    private TargetPlatform targetPlatform;

    public RunnerCreatorMojo() {
    }

    public RunnerCreatorMojo(String baseDir, String targetDir, String zipPath) {
        this.baseDir = baseDir;
        this.targetDir = targetDir;
        this.zipName = zipPath;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.unzipFile(this.zipName);
        this.initilizeRunnerFiles();
        this.updateManifest();
        this.updateTargetPlatform();
    }

    private void updateManifest() {
        String bundleLine = " " + this.connectorUpdateSite.getManifestUnit().getId() + BUNDLE_VERSION_0_0_0;
        try {
            this.manifest.updateRequiredBundle(bundleLine);
        }
        catch (ManifestUpdateException e) {
            e.printStackTrace();
            throw new CreatorMojoException(e.getMessage());
        }
    }

    private void updateTargetPlatform() {
        try {
            if (!StringUtils.isEmpty((String)this.externalPlatform) && new File(this.externalPlatform).exists()) {
                this.replaceTargetPlatform();
            }
            this.targetPlatform.addLocation(this.connectorUpdateSite);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CreatorMojoException(e.getMessage());
        }
    }

    private void replaceTargetPlatform() throws IOException {
        FileUtils.forceDelete((File)new File(this.targetDir, this.platformPath));
        FileUtils.copyFile((File)new File(this.externalPlatform), (File)new File(this.targetDir, this.platformPath));
        this.initializeTargetPlatform();
    }

    public void unzipFile(String zipFile) {
        try {
            File folder = new File(this.targetDir);
            if (!folder.exists()) {
                folder.mkdir();
            }
            this.getLog().debug((CharSequence)("Unzip directory :: " + folder.getCanonicalPath()));
            ZipInputStream zis = new ZipInputStream(((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(zipFile));
            ZipEntry ze = zis.getNextEntry();
            byte[] buffer = new byte[1024];
            while (ze != null) {
                String fileName = ze.getName();
                File newFile = new File(this.targetDir, fileName);
                new File(newFile.getParent()).mkdirs();
                if (!ze.isDirectory()) {
                    int len;
                    this.getLog().debug((CharSequence)("File unzip : " + newFile.getAbsoluteFile()));
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.flush();
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
            zis.closeEntry();
            zis.close();
            this.getLog().debug((CharSequence)"Done");
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CreatorMojoException(e.getMessage());
        }
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setManifestPath(String manifestPath) {
        this.manifestPath = manifestPath;
    }

    public void setOutputDir(String targetDir) {
        this.targetDir = targetDir;
    }

    private void initilizeRunnerFiles() {
        try {
            this.initializeManifest();
            this.initializeTargetPlatform();
            this.initializeUpdateSite();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CreatorMojoException(e.getMessage());
        }
    }

    private void initializeUpdateSite() throws IOException {
        this.connectorUpdateSite = new UpdateSite(this.targetDir);
    }

    private void initializeTargetPlatform() throws TargetPlatformUpdateException {
        this.targetPlatform = new TargetPlatform(new File(this.targetDir, this.platformPath).getPath());
    }

    private void initializeManifest() {
        this.manifest = new Manifest(new File(this.targetDir, this.manifestPath).getPath());
    }

    public void setPlatformPath(String platformPath) {
        this.platformPath = platformPath;
    }

    public void setExternalPlatform(String externalPlatform) {
        this.externalPlatform = externalPlatform;
    }
}

