package com.mule.connectors.interop;

import com.mule.connectors.interop.model.TestDataFile;
import edu.emory.mathcs.backport.java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.*;

import java.io.File;
import java.io.IOException;

@Mojo( name = "run")
@Execute( goal = "run")
public class RunExecutorMojo extends AbstractMojo {

    protected static final String testDataNameFormat = ".*test(d|D)ata\\.xml";
    protected static final String testDataOverrideNameFormat = ".*test(d|D)ata.*(o|O)verride?\\.xml";

    private final String GENERATED_REPORTS_PATH = "interop-ce-project/ce-interop-testsuite/target/surefire-reports";

    @Parameter( defaultValue = "${project.basedir}", readonly = true )
    protected File basedir;

    @Parameter( defaultValue = "${project.build.directory}", readonly = true )
    protected File target;

    @Parameter( defaultValue = "${settings}", readonly = true )
    protected Settings settings;

    @Parameter( defaultValue = "${project}", readonly = true )
    protected MavenProject project;

    @Parameter(property = "logLevel", defaultValue = "INFO", readonly = true )
    private String logLevel;

    @Parameter(property = "playbackDelay", defaultValue = "5", readonly = true )
    private Integer playbackDelay;

    @Parameter(property = "testConnect", defaultValue = "false", readonly = true )
    private Boolean testConnect;

    @Parameter(property = "testDMapper", defaultValue = "false", readonly = true )
    private Boolean testDMapper;

    @Parameter(property = "testXml", defaultValue = "false", readonly = true )
    private Boolean testXml;

    @Parameter( property = "testData", defaultValue = "", readonly = true )
    private String testDataPath;

    @Parameter( property = "testDataOverride", defaultValue = "", readonly = true)
    private String testDataOverridePath;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {

        TestDataFile testDataFile;
        TestDataFile testDataFileOverride;

        try{
            testDataFile = StringUtils.isEmpty(testDataPath) ?  new TestDataFile(basedir, testDataNameFormat) : new TestDataFile(testDataPath);
            testDataFileOverride = StringUtils.isEmpty(testDataOverridePath) ? new TestDataFile(basedir, testDataOverrideNameFormat) : new TestDataFile(testDataOverridePath);
        } catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }

        try {
            String[] command = new String[] {"install",
                                    "-Dsuite.testData=" + testDataFile.getPath(),
                                    "-Dsuite.testDataOverride=" + testDataFileOverride.getPath(),
                                    "-Dsuite.testConnect=" + testConnect.toString(),
                                    "-Dsuite.testDMapper=" + testDMapper.toString(),
                                    "-Dsuite.testXml=" + testXml.toString(),
                                    "-Dsuite.playbackDelay=" + playbackDelay.toString(),
                                    "-Dsuite.logLevel=" + logLevel};


            InvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(new File(target, "interop-ce-project/pom.xml"));
            request.setGoals(Arrays.asList(command));

            Invoker invoker = new DefaultInvoker();
            InvocationResult result = invoker.execute( request );

            try {
                File reportSource = new File(target, GENERATED_REPORTS_PATH);
                File reportTarget = new File(target, "surefire-reports");
                File textReport = new File(reportTarget, "suite.ConnectorsInteropTestSuite.txt");

                if (reportSource.exists()) {
                    FileUtils.deleteDirectory(reportTarget);
                    FileUtils.moveDirectory(reportSource, reportTarget);
                    if (textReport.exists()) {
                        FileUtils.writeStringToFile(textReport, FileUtils.readFileToString(textReport)
                                .replaceAll(" skipped", " skipped\n")
                                .replaceAll(" sectest", " sec\ntest"));
                    }
                } else {
                    getLog().error("No tests results found, none executed.");
                }

                FileUtils.deleteDirectory(new File(target, "interop-ce-project"));

            } catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage());
            }

        } catch (MavenInvocationException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());

        }

    }

}
