package com.mule.connectors.interop.model;

import com.mule.connectors.interop.exceptions.CreatorMojoException;
import com.mule.connectors.testdata.model.JarDependency;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;

/**
 * @author Mulesoft, Inc
 */
public class DependenciesPom {

    public static final String DEPENDENCIES_POM_PATH = "interop-ce-project/ce-interop-testsuite/dependenciesPom.xml";

    private Model pom;
    private String path;

    public DependenciesPom(String path){
        this(new File(path));
    }

    public DependenciesPom(File pom){
        if (pom == null || !pom.exists()){
            throw new CreatorMojoException("Invalid reference to dependenciesPom.xml");
        }

        try {

            MavenXpp3Reader reader = new MavenXpp3Reader();
            this.pom = reader.read(new FileReader(pom));

            this.path = pom.getCanonicalPath();

        } catch (IOException e) {
            throw new CreatorMojoException(e.getMessage());
        } catch (XmlPullParserException e) {
            throw new CreatorMojoException(e.getMessage());
        }

    }


    public void updateDependencies(List<JarDependency> connectorDependencies){

        for (JarDependency jar: connectorDependencies){
            if (StringUtils.isEmpty(jar.getSystemPath())){

                Dependency d = new Dependency();

                d.setGroupId(jar.getGroupId());
                d.setArtifactId(jar.getArtifactId());
                d.setVersion(jar.getVersion());

                this.pom.addDependency(d);
            }
        }

        export();
    }

    private void export() {
        try {
            MavenXpp3Writer writer = new MavenXpp3Writer();
            writer.write(new FileWriter(this.path), this.pom);
        } catch (IOException e) {
            e.printStackTrace();
            throw new CreatorMojoException("Unable to update project's dependenciesPom :: " + e.getMessage());
        }
    }
}
