package com.mule.connectors.interop.model;

import com.mule.connectors.interop.exceptions.ManifestUpdateException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import java.io.*;

/**
 * @author Mulesoft, Inc
 */
public class ManifestFile {

    private File manifest;

    public ManifestFile(String manifestPath){
        manifest = new File(manifestPath);
    }

    public void updateRequiredBundle(String newBundle) throws ManifestUpdateException{

        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            File newManifest = new File(manifest.getCanonicalPath() + ".tmp");

            reader = new BufferedReader(new FileReader(manifest));
            newManifest.createNewFile();
            writer = new BufferedWriter(new FileWriter(newManifest));

            String currentLine;
            boolean inBundleTag = false;
            while ((currentLine = reader.readLine()) != null &&
                    (!inBundleTag || StringUtils.contains(currentLine, ",")))
            {
                writer.write(currentLine);
                writer.newLine();

                if (!inBundleTag)
                    inBundleTag = StringUtils.contains(currentLine, "Require-Bundle:");
            }

            if (currentLine != null){
                String nextLine = " " + currentLine.trim() + ",";
                writer.write(nextLine);
                writer.newLine();
                writer.write(newBundle);
                //writer.newLine();
            }

            while ((currentLine = reader.readLine()) != null){
                writer.write(currentLine);
                writer.newLine();
            }

            reader.close();
            writer.flush();
            writer.close();

            FileUtils.forceDelete(manifest);
            FileUtils.moveFile(newManifest, manifest);

        } catch (Exception e) {
            e.printStackTrace();
            throw new ManifestUpdateException(e.getMessage());

        } finally {
            IOUtils.closeQuietly(reader);
            IOUtils.closeQuietly(writer);
        }
    }

}
