package com.mule.connectors.interop.model;

import com.mule.connectors.interop.exceptions.RunnerMojoException;
import org.apache.commons.lang.StringUtils;

import java.io.File;
import java.io.IOException;

import static com.mule.connectors.interop.Utils.findFileInFolder;

/**
 * @author Mulesoft, Inc
 */
public class TestDataFile {

    private String path;

    public TestDataFile(String filePath) throws RunnerMojoException, IOException {
        if (StringUtils.isEmpty(filePath)){
            throw new RunnerMojoException("Path for testData cannot be empty");
        }

        if (!new File(filePath).exists()){
            throw new RunnerMojoException("TestData file not found in path :: " + filePath);
        }

        this.path = new File(filePath).getCanonicalPath();
    }

    public TestDataFile(File basedir, String nameFormat, String resourcesPath, String generatedPath) throws RunnerMojoException {

        File testResources = new File(basedir, resourcesPath);
        File generatedResources = new File(basedir, generatedPath);


        this.path = findFileInFolder(testResources, nameFormat);

        if (StringUtils.isEmpty(path)){
            path = findFileInFolder(generatedResources, nameFormat);
        }

        if (StringUtils.isEmpty(path)){
            throw new RunnerMojoException("No testData file found matching " + nameFormat);
        }
    }

    public TestDataFile(File basedir, String nameFormat) throws RunnerMojoException {
        this(basedir, nameFormat, "src/test/resources", "src/test/resources/generated");
    }

    public String getPath() {
        return path;
    }
}
