/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop;

import com.mule.connectors.interop.model.TestDataFile;
import edu.emory.mathcs.backport.java.util.Arrays;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Execute;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.invoker.DefaultInvocationRequest;
import org.apache.maven.shared.invoker.DefaultInvoker;
import org.apache.maven.shared.invoker.InvocationRequest;
import org.apache.maven.shared.invoker.InvocationResult;
import org.apache.maven.shared.invoker.MavenInvocationException;

@Mojo(name="run")
@Execute(goal="run")
public class RunExecutorMojo
extends AbstractMojo {
    protected static final String testDataNameFormat = ".*test(d|D)ata\\.xml";
    protected static final String testDataOverrideNameFormat = ".*test(d|D)ata.*(o|O)verride?\\.xml";
    private final String GENERATED_REPORTS_PATH = "interop-ce-project/ce-interop-testsuite/target/surefire-reports";
    @Parameter(defaultValue="${project.basedir}", readonly=true)
    protected File basedir;
    @Parameter(defaultValue="${project.build.directory}", readonly=true)
    protected File target;
    @Parameter(defaultValue="${settings}", readonly=true)
    protected Settings settings;
    @Parameter(defaultValue="${project}", readonly=true)
    protected MavenProject project;
    @Parameter(property="logLevel", defaultValue="INFO", readonly=true)
    private String logLevel;
    @Parameter(property="playbackDelay", defaultValue="5", readonly=true)
    private Integer playbackDelay;
    @Parameter(property="testConnect", defaultValue="false", readonly=true)
    private Boolean testConnect;
    @Parameter(property="testDMapper", defaultValue="false", readonly=true)
    private Boolean testDMapper;
    @Parameter(property="testXml", defaultValue="false", readonly=true)
    private Boolean testXml;
    @Parameter(property="testData", defaultValue="", readonly=true)
    private String testDataPath;
    @Parameter(property="testDataOverride", defaultValue="", readonly=true)
    private String testDataOverridePath;

    public void execute() throws MojoExecutionException, MojoFailureException {
        TestDataFile testDataFileOverride;
        TestDataFile testDataFile;
        try {
            testDataFile = StringUtils.isEmpty((String)this.testDataPath) ? new TestDataFile(this.basedir, testDataNameFormat) : new TestDataFile(this.testDataPath);
            testDataFileOverride = StringUtils.isEmpty((String)this.testDataOverridePath) ? new TestDataFile(this.basedir, testDataOverrideNameFormat) : new TestDataFile(this.testDataOverridePath);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
        try {
            Object[] command = new String[]{"install", "-Dsuite.testData=" + testDataFile.getPath(), "-Dsuite.testDataOverride=" + testDataFileOverride.getPath(), "-Dsuite.testConnect=" + this.testConnect.toString(), "-Dsuite.testDMapper=" + this.testDMapper.toString(), "-Dsuite.testXml=" + this.testXml.toString(), "-Dsuite.playbackDelay=" + this.playbackDelay.toString(), "-Dsuite.logLevel=" + this.logLevel};
            DefaultInvocationRequest request = new DefaultInvocationRequest();
            request.setPomFile(new File(this.target, "interop-ce-project/pom.xml"));
            request.setGoals(Arrays.asList((Object[])command));
            DefaultInvoker invoker = new DefaultInvoker();
            InvocationResult result = invoker.execute((InvocationRequest)request);
            try {
                File reportSource = new File(this.target, "interop-ce-project/ce-interop-testsuite/target/surefire-reports");
                File reportTarget = new File(this.target, "surefire-reports");
                File textReport = new File(reportTarget, "suite.ConnectorsInteropTestSuite.txt");
                if (reportSource.exists()) {
                    FileUtils.deleteDirectory((File)reportTarget);
                    FileUtils.moveDirectory((File)reportSource, (File)reportTarget);
                    if (textReport.exists()) {
                        FileUtils.writeStringToFile((File)textReport, (String)FileUtils.readFileToString((File)textReport).replaceAll(" skipped", " skipped\n").replaceAll(" sectest", " sec\ntest"));
                    }
                } else {
                    this.getLog().error((CharSequence)"No tests results found, none executed.");
                }
                FileUtils.deleteDirectory((File)new File(this.target, "interop-ce-project"));
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new MojoExecutionException(e.getMessage());
            }
        }
        catch (MavenInvocationException e) {
            e.printStackTrace();
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

