/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model;

import com.mule.connectors.interop.exceptions.ManifestUpdateException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

public class ManifestFile {
    private File manifest;

    public ManifestFile(String manifestPath) {
        this.manifest = new File(manifestPath);
    }

    public void updateRequiredBundle(String newBundle) throws ManifestUpdateException {
        BufferedReader reader = null;
        BufferedWriter writer = null;
        try {
            String currentLine;
            File newManifest = new File(this.manifest.getCanonicalPath() + ".tmp");
            reader = new BufferedReader(new FileReader(this.manifest));
            newManifest.createNewFile();
            writer = new BufferedWriter(new FileWriter(newManifest));
            boolean inBundleTag = false;
            while ((currentLine = reader.readLine()) != null && (!inBundleTag || StringUtils.contains((String)currentLine, (String)","))) {
                writer.write(currentLine);
                writer.newLine();
                if (inBundleTag) continue;
                inBundleTag = StringUtils.contains((String)currentLine, (String)"Require-Bundle:");
            }
            if (currentLine != null) {
                String nextLine = " " + currentLine.trim() + ",";
                writer.write(nextLine);
                writer.newLine();
                writer.write(newBundle);
            }
            while ((currentLine = reader.readLine()) != null) {
                writer.write(currentLine);
                writer.newLine();
            }
            reader.close();
            writer.flush();
            writer.close();
            FileUtils.forceDelete((File)this.manifest);
            FileUtils.moveFile((File)newManifest, (File)this.manifest);
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
                throw new ManifestUpdateException(e.getMessage());
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(reader);
                IOUtils.closeQuietly(writer);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((Reader)reader);
        IOUtils.closeQuietly((Writer)writer);
    }
}

