/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model;

import com.mule.connectors.interop.exceptions.TargetPlatformUpdateException;
import com.mule.connectors.interop.model.UpdateSite;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TargetPlatform {
    private final XPath xpath;
    private File platform;
    private Document doc;

    public TargetPlatform(String platformPath) throws TargetPlatformUpdateException {
        try {
            this.platform = new File(platformPath);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.doc = builder.parse(this.platform);
            XPathFactory xPathfactory = XPathFactory.newInstance();
            this.xpath = xPathfactory.newXPath();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            throw new TargetPlatformUpdateException(e.getMessage());
        }
        catch (SAXException e) {
            e.printStackTrace();
            throw new TargetPlatformUpdateException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TargetPlatformUpdateException(e.getMessage());
        }
    }

    public void updateLocation(String oldLocation, String newLocation) throws XPathExpressionException, TransformerException, IOException {
        String studioPattern = "//repository[contains(@location, '" + oldLocation + "')]";
        Element studioRepository = (Element)this.xpath.compile(studioPattern).evaluate(this.doc.getDocumentElement(), XPathConstants.NODE);
        studioRepository.setAttribute("location", newLocation);
        this.exportToFile(this.doc);
    }

    public void addLocation(UpdateSite updateSite) throws TargetPlatformUpdateException {
        try {
            if (!this.containsUnit(updateSite.getPlatformUnit().getId())) {
                Element location = this.createNewLocation(this.doc.getDocumentElement());
                Element unit = this.doc.createElement("unit");
                unit.setAttribute("id", updateSite.getPlatformUnit().getId());
                unit.setAttribute("version", updateSite.getPlatformUnit().getVersion());
                location.appendChild(unit);
                Element repository = this.doc.createElement("repository");
                repository.setAttribute("location", updateSite.getLocation());
                location.appendChild(repository);
                this.exportToFile(this.doc);
            }
        }
        catch (XPathExpressionException e) {
            e.printStackTrace();
            throw new TargetPlatformUpdateException(e.getMessage());
        }
        catch (TransformerException e) {
            e.printStackTrace();
            throw new TargetPlatformUpdateException(e.getMessage());
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new TargetPlatformUpdateException(e.getMessage());
        }
    }

    private boolean containsUnit(String unit) throws IOException {
        return FileUtils.readLines((File)this.platform).contains(unit);
    }

    private Element createNewLocation(Element target) throws XPathExpressionException {
        Element newLocation = this.doc.createElement("location");
        newLocation.setAttribute("includeAllPlatforms", "false");
        newLocation.setAttribute("includeConfigurePhase", "true");
        newLocation.setAttribute("includeMode", "planner");
        newLocation.setAttribute("includeSource", "true");
        newLocation.setAttribute("type", "InstallableUnit");
        Element locations = (Element)this.xpath.compile("./locations").evaluate(target, XPathConstants.NODE);
        locations.appendChild(newLocation);
        return newLocation;
    }

    private void exportToFile(Document doc) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        File newPlatform = new File(this.platform.getCanonicalPath() + ".tmp");
        StreamResult result = new StreamResult(newPlatform);
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "0");
        transformer.transform(source, result);
        FileUtils.forceDelete((File)this.platform);
        FileUtils.moveFile((File)newPlatform, (File)this.platform);
    }
}

