/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model;

import com.mule.connectors.interop.Utils;
import com.mule.connectors.interop.exceptions.RunnerMojoException;
import java.io.File;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class TestDataFile {
    private String path;

    public TestDataFile(String filePath) throws RunnerMojoException, IOException {
        if (StringUtils.isEmpty((String)filePath)) {
            throw new RunnerMojoException("Path for testData cannot be empty");
        }
        if (!new File(filePath).exists()) {
            throw new RunnerMojoException("TestData file not found in path :: " + filePath);
        }
        this.path = new File(filePath).getCanonicalPath();
    }

    public TestDataFile(File basedir, String nameFormat, String resourcesPath, String generatedPath) throws RunnerMojoException {
        File testResources = new File(basedir, resourcesPath);
        File generatedResources = new File(basedir, generatedPath);
        this.path = Utils.findFileInFolder(testResources, nameFormat);
        if (StringUtils.isEmpty((String)this.path)) {
            this.path = Utils.findFileInFolder(generatedResources, nameFormat);
        }
        if (StringUtils.isEmpty((String)this.path)) {
            throw new RunnerMojoException("No testData file found matching " + nameFormat);
        }
    }

    public TestDataFile(File basedir, String nameFormat) throws RunnerMojoException {
        this(basedir, nameFormat, "src/test/resources", "src/test/resources/generated");
    }

    public String getPath() {
        return this.path;
    }
}

