/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop;

import com.mule.connectors.interop.exceptions.CreatorMojoException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    static Logger logger = LogManager.getLogger(Utils.class);

    public static void unzipFile(String targetDir, String zipFile) {
        try {
            String outputPath = new File(targetDir, StringUtils.remove((String)zipFile, (String)".zip")).getCanonicalPath();
            File folder = new File(outputPath);
            if (!folder.exists()) {
                folder.mkdir();
            }
            logger.debug("Unzip directory :: " + folder.getCanonicalPath());
            ZipInputStream zis = new ZipInputStream(Utils.class.getClassLoader().getResourceAsStream(zipFile));
            Utils.unzipContent(outputPath, zis);
        }
        catch (IOException e) {
            throw new CreatorMojoException(e);
        }
    }

    private static void unzipContent(String outputPath, ZipInputStream zis) throws IOException {
        ZipEntry ze = zis.getNextEntry();
        byte[] buffer = new byte[1024];
        while (ze != null) {
            String fileName = ze.getName();
            File newFile = new File(outputPath, fileName);
            new File(newFile.getParent()).mkdirs();
            if (!ze.isDirectory()) {
                int len;
                logger.debug("File unzip : " + newFile.getAbsoluteFile());
                FileOutputStream fos = new FileOutputStream(newFile);
                while ((len = zis.read(buffer)) > 0) {
                    fos.write(buffer, 0, len);
                }
                fos.flush();
                fos.close();
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        logger.debug("Unzip completed");
    }

    public static String findFileInFolder(File source, String nameExpression) {
        return Utils.findFileInFolder(source, nameExpression, 0, 0);
    }

    public static String findFileInFolder(File source, String nameExpression, int initDepth, int maxDepth) {
        String path = "";
        if (source == null || !source.exists() || !source.isDirectory()) {
            return path;
        }
        File[] contents = source.listFiles();
        if (contents == null) {
            return path;
        }
        int currentDepth = initDepth;
        for (File file : contents) {
            if (file.isDirectory() && currentDepth < maxDepth) {
                path = Utils.findFileInFolder(file, nameExpression, ++currentDepth, maxDepth);
            } else if (Pattern.matches(nameExpression, file.getName()) && !FileUtils.sizeOfAsBigInteger((File)file).equals(BigInteger.ZERO)) {
                try {
                    path = file.getCanonicalPath();
                }
                catch (IOException e) {
                    logger.debug("An exception was thrown looking for file '" + nameExpression + "' in folder '" + source.getPath());
                    logger.debug("Message :: " + e.getMessage());
                    return "";
                }
            }
            if (!path.isEmpty()) break;
        }
        return path;
    }
}

