/*
 * Decompiled with CFR 0.152.
 */
package com.mule.connectors.interop.model;

import com.mule.connectors.interop.model.ManifestUnit;
import com.mule.connectors.interop.model.PlatformUnit;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.lang.SystemUtils;
import org.xml.sax.SAXException;

public class UpdateSite {
    public static final String JAR_PREFIX = "jar:file:";
    private final String UPDATESITE_PATH = "/UpdateSite.zip!";
    private final String CONTENT_PATH = "/update-site/content.xml";
    private final File updateSite;
    private final String location;
    private ManifestUnit manifestUnit;
    private PlatformUnit platformUnit;

    public UpdateSite(String targetDir) throws IOException {
        this.updateSite = new File(targetDir, "/UpdateSite.zip!");
        try {
            File content = new File(targetDir, "/update-site/content.xml");
            this.manifestUnit = new ManifestUnit(content.getCanonicalPath());
            this.platformUnit = new PlatformUnit(content.getCanonicalPath());
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        catch (XPathExpressionException e) {
            throw new IOException(e);
        }
        this.location = this.buildLocation();
    }

    public ManifestUnit getManifestUnit() {
        return this.manifestUnit;
    }

    public PlatformUnit getPlatformUnit() {
        return this.platformUnit;
    }

    public String getLocation() {
        return this.location;
    }

    private String buildLocation() throws IOException {
        return JAR_PREFIX + (SystemUtils.IS_OS_WINDOWS ? "/" : "") + this.updateSite.getCanonicalPath().replaceAll("\\\\", "/") + "/";
    }
}

